/*
 Copyright (c) 2010, Yahoo! Inc. All rights reserved.
 Code licensed under the BSD License:
 http://developer.yahoo.com/yui/license.html
 version: 3.3.0
 build: 3167
 */
YUI.add('autocomplete-list',function(Y){var Lang=Y.Lang,Node=Y.Node,YArray=Y.Array,KEY_TAB=9,_CLASS_ITEM='_CLASS_ITEM',_CLASS_ITEM_ACTIVE='_CLASS_ITEM_ACTIVE',_CLASS_ITEM_HOVER='_CLASS_ITEM_HOVER',_SELECTOR_ITEM='_SELECTOR_ITEM',ACTIVE_ITEM='activeItem',ALWAYS_SHOW_LIST='alwaysShowList',CIRCULAR='circular',HOVERED_ITEM='hoveredItem',ID='id',ITEM='item',LIST='list',RESULT='result',RESULTS='results',VISIBLE='visible',WIDTH='width',EVT_SELECT='select',List=Y.Base.create('autocompleteList',Y.Widget,[Y.AutoCompleteBase,Y.WidgetPosition,Y.WidgetPositionAlign,Y.WidgetStack],{ARIA_TEMPLATE:'<div/>',ITEM_TEMPLATE:'<li/>',LIST_TEMPLATE:'<ul/>',initializer:function(){var inputNode=this.get('inputNode');if(!inputNode){Y.error('No inputNode specified.');return;}
this._inputNode=inputNode;this._listEvents=[];this.DEF_PARENT_NODE=inputNode.get('parentNode');this[_CLASS_ITEM]=this.getClassName(ITEM);this[_CLASS_ITEM_ACTIVE]=this.getClassName(ITEM,'active');this[_CLASS_ITEM_HOVER]=this.getClassName(ITEM,'hover');this[_SELECTOR_ITEM]='.'+this[_CLASS_ITEM];this.publish(EVT_SELECT,{defaultFn:this._defSelectFn});},destructor:function(){while(this._listEvents.length){this._listEvents.pop().detach();}},bindUI:function(){this._bindInput();this._bindList();},renderUI:function(){var ariaNode=this._createAriaNode(),contentBox=this.get('contentBox'),inputNode=this._inputNode,listNode,parentNode=inputNode.get('parentNode');listNode=this._createListNode();this._set('listNode',listNode);contentBox.append(listNode);inputNode.addClass(this.getClassName('input')).setAttrs({'aria-autocomplete':LIST,'aria-expanded':false,'aria-owns':listNode.get('id'),role:'combobox'});parentNode.append(ariaNode);this._ariaNode=ariaNode;this._boundingBox=this.get('boundingBox');this._contentBox=contentBox;this._listNode=listNode;this._parentNode=parentNode;},syncUI:function(){this._syncResults();this._syncVisibility();},hide:function(){return this.get(ALWAYS_SHOW_LIST)?this:this.set(VISIBLE,false);},selectItem:function(itemNode){if(itemNode){if(!itemNode.hasClass(this[_CLASS_ITEM])){return this;}}else{itemNode=this.get(ACTIVE_ITEM);if(!itemNode){return this;}}
this.fire(EVT_SELECT,{itemNode:itemNode,result:itemNode.getData(RESULT)});return this;},_activateNextItem:function(){var item=this.get(ACTIVE_ITEM),nextItem;if(item){nextItem=item.next(this[_SELECTOR_ITEM])||(this.get(CIRCULAR)?null:item);}else{nextItem=this._getFirstItemNode();}
this.set(ACTIVE_ITEM,nextItem);return this;},_activatePrevItem:function(){var item=this.get(ACTIVE_ITEM),prevItem=item?item.previous(this[_SELECTOR_ITEM]):this.get(CIRCULAR)&&this._getLastItemNode();this.set(ACTIVE_ITEM,prevItem||null);return this;},_add:function(items){var itemNodes=[];YArray.each(Lang.isArray(items)?items:[items],function(item){itemNodes.push(this._createItemNode(item).setData(RESULT,item));},this);itemNodes=Y.all(itemNodes);this._listNode.append(itemNodes.toFrag());return itemNodes;},_ariaSay:function(stringId,subs){var message=this.get('strings.'+stringId);this._ariaNode.setContent(subs?Lang.sub(message,subs):message);},_bindInput:function(){var inputNode=this._inputNode,alignNode,alignWidth,tokenInput;if(this.get('align')===null){tokenInput=this.get('tokenInput');alignNode=(tokenInput&&tokenInput.get('boundingBox'))||inputNode;this.set('align',{node:alignNode,points:['tl','bl']});if(!this.get(WIDTH)&&(alignWidth=alignNode.get('offsetWidth'))){this.set(WIDTH,alignWidth);}}
this._listEvents.push(inputNode.on('blur',this._onListInputBlur,this));},_bindList:function(){this._listEvents.concat([this.after({mouseover:this._afterMouseOver,mouseout:this._afterMouseOut,activeItemChange:this._afterActiveItemChange,alwaysShowListChange:this._afterAlwaysShowListChange,hoveredItemChange:this._afterHoveredItemChange,resultsChange:this._afterResultsChange,visibleChange:this._afterVisibleChange}),this._listNode.delegate('click',this._onItemClick,this[_SELECTOR_ITEM],this)]);},_clear:function(){this.set(ACTIVE_ITEM,null);this._set(HOVERED_ITEM,null);this._listNode.get('children').remove(true);},_createAriaNode:function(){var ariaNode=Node.create(this.ARIA_TEMPLATE);return ariaNode.addClass(this.getClassName('aria')).setAttrs({'aria-live':'polite',role:'status'});},_createItemNode:function(result){var itemNode=Node.create(this.ITEM_TEMPLATE);return itemNode.addClass(this[_CLASS_ITEM]).setAttrs({id:Y.stamp(itemNode),role:'option'}).setAttribute('data-text',result.text).append(result.display);},_createListNode:function(){var listNode=Node.create(this.LIST_TEMPLATE);return listNode.addClass(this.getClassName(LIST)).setAttrs({id:Y.stamp(listNode),role:'listbox'});},_getFirstItemNode:function(){return this._listNode.one(this[_SELECTOR_ITEM]);},_getLastItemNode:function(){return this._listNode.one(this[_SELECTOR_ITEM]+':last-child');},_syncResults:function(results){var items;if(!results){results=this.get(RESULTS);}
this._clear();if(results.length){items=this._add(results);this._ariaSay('items_available');}
if(this.get('activateFirstItem')&&!this.get(ACTIVE_ITEM)){this.set(ACTIVE_ITEM,this._getFirstItemNode());}},_syncVisibility:function(visible){if(this.get(ALWAYS_SHOW_LIST)){visible=true;this.set(VISIBLE,visible);}
if(typeof visible==='undefined'){visible=this.get(VISIBLE);}
this._inputNode.set('aria-expanded',visible);this._boundingBox.set('aria-hidden',!visible);if(visible){this._syncUIPosAlign();}else{this.set(ACTIVE_ITEM,null);this._set(HOVERED_ITEM,null);this._boundingBox.get('offsetWidth');}},_afterActiveItemChange:function(e){var inputNode=this._inputNode,newVal=e.newVal,prevVal=e.prevVal;if(prevVal&&prevVal._node){prevVal.removeClass(this[_CLASS_ITEM_ACTIVE]);}
if(newVal){newVal.addClass(this[_CLASS_ITEM_ACTIVE]);inputNode.set('aria-activedescendant',newVal.get(ID));}else{inputNode.removeAttribute('aria-activedescendant');}
if(this.get('scrollIntoView')){(newVal||inputNode).scrollIntoView();}},_afterAlwaysShowListChange:function(e){this.set(VISIBLE,e.newVal||this.get(RESULTS).length>0);},_afterHoveredItemChange:function(e){var newVal=e.newVal,prevVal=e.prevVal;if(prevVal){prevVal.removeClass(this[_CLASS_ITEM_HOVER]);}
if(newVal){newVal.addClass(this[_CLASS_ITEM_HOVER]);}},_afterMouseOver:function(e){var itemNode=e.domEvent.target.ancestor(this[_SELECTOR_ITEM],true);this._mouseOverList=true;if(itemNode){this._set(HOVERED_ITEM,itemNode);}},_afterMouseOut:function(){this._mouseOverList=false;this._set(HOVERED_ITEM,null);},_afterResultsChange:function(e){this._syncResults(e.newVal);if(!this.get(ALWAYS_SHOW_LIST)){this.set(VISIBLE,!!e.newVal.length);}},_afterVisibleChange:function(e){this._syncVisibility(!!e.newVal);},_onListInputBlur:function(e){if(!this._mouseOverList||this._lastInputKey===KEY_TAB){this.hide();}},_onItemClick:function(e){var itemNode=e.currentTarget;this.set(ACTIVE_ITEM,itemNode);this.selectItem(itemNode);},_defSelectFn:function(e){var text=e.result.text;this._inputNode.focus();this._updateValue(text);this._ariaSay('item_selected',{item:text});this.hide();}},{ATTRS:{activateFirstItem:{value:false},activeItem:{setter:Y.one,value:null},alwaysShowList:{value:false},circular:{value:true},hoveredItem:{readOnly:true,value:null},listNode:{readOnly:true,value:null},scrollIntoView:{value:false},strings:{valueFn:function(){return Y.Intl.get('autocomplete-list');}},tabSelect:{value:true},visible:{value:false}},CSS_PREFIX:Y.ClassNameManager.getClassName('aclist')});Y.AutoCompleteList=List;Y.AutoComplete=List;},'3.3.0',{lang:['en'],requires:['autocomplete-base','selector-css3','widget','widget-position','widget-position-align','widget-stack'],after:['autocomplete-sources'],skinnable:true});